<?php
require_once("./config/session.php");
require_once("./config/connection.php");

// Set JSON header
header('Content-Type: application/json');

// Rate limiting
session_start();
$rate_limit_key = 'api_requests_' . ($_SERVER['REMOTE_ADDR'] ?? 'unknown');
if (!isset($_SESSION[$rate_limit_key])) {
    $_SESSION[$rate_limit_key] = ['count' => 0, 'time' => time()];
}

// Reset counter after 1 minute
if (time() - $_SESSION[$rate_limit_key]['time'] > 60) {
    $_SESSION[$rate_limit_key] = ['count' => 0, 'time' => time()];
}

// Allow 60 requests per minute
if ($_SESSION[$rate_limit_key]['count'] >= 60) {
    http_response_code(429);
    echo json_encode(["error" => "Rate limit exceeded"]);
    exit;
}

$_SESSION[$rate_limit_key]['count']++;

// Fetch all settings from the app_settings table using prepared statement
$settings_query = "SELECT * FROM app_settings LIMIT 1";
$stmt = $mysqli->prepare($settings_query);
$stmt->execute();
$result_settings = $stmt->get_result();

if ($result_settings->num_rows > 0) {
    $app_settings = $result_settings->fetch_assoc();
    $purchase_code = $app_settings['purchase_code'];
} else {
    http_response_code(404);
    echo json_encode(["error" => "No resource found"]);
    exit;
}
$stmt->close();

// Fetch POST data with validation
$get = get_str('get');
$key = get_str('key');

// Handle API access with a valid key
if (!empty($key) && hash_equals(trim($purchase_code), trim($key))) {
    switch ($get) {
        case 'app_info':
            // Fetch menu data using prepared statement
            $menu_query = "SELECT * FROM app_menu ORDER BY order_id";
            $stmt = $mysqli->prepare($menu_query);
            $stmt->execute();
            $result_menu = $stmt->get_result();

            $app_menu = [];
            while ($row = $result_menu->fetch_assoc()) {
                $app_menu[] = $row;
            }
            $stmt->close();

            // Prepare and send the response
            $data = [
                'app_settings' => $app_settings,
                'app_menu' => $app_menu
            ];
            
            http_response_code(200);
            echo json_encode($data);
            break;

        default:
            http_response_code(400);
            echo json_encode(["message" => "Invalid action"]);
            break;
    }
} elseif (!empty($key)) {
    http_response_code(403);
    echo json_encode(["message" => "Invalid purchase key"]);
} else {
    http_response_code(404);
    include("./pages/404.php");
}

exit;
?>